/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange;

import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import ru.bclib.BCLib;
import ru.bclib.api.dataexchange.BaseDataHandler;
import ru.bclib.api.dataexchange.handler.autosync.Chunker;

public abstract class DataHandler
extends BaseDataHandler {
    protected DataHandler(class_2960 identifier, boolean originatesOnServer) {
        super(identifier, originatesOnServer);
    }

    protected boolean prepareData(boolean isClient) {
        return true;
    }

    protected abstract void serializeData(class_2540 var1, boolean var2);

    protected abstract void deserializeIncomingData(class_2540 var1, PacketSender var2, boolean var3);

    protected abstract void runOnGameThread(class_310 var1, MinecraftServer var2, boolean var3);

    @Override
    @Environment(value=EnvType.CLIENT)
    void receiveFromServer(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        this.deserializeIncomingData(buf, responseSender, true);
        Runnable runner = () -> this.runOnGameThread(client, null, true);
        if (this.isBlocking()) {
            client.method_19537(runner);
        } else {
            client.execute(runner);
        }
    }

    @Override
    void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        super.receiveFromClient(server, player, handler, buf, responseSender);
        this.deserializeIncomingData(buf, responseSender, false);
        Runnable runner = () -> this.runOnGameThread(null, server, false);
        if (this.isBlocking()) {
            server.method_19537(runner);
        } else {
            server.execute(runner);
        }
    }

    @Override
    void sendToClient(MinecraftServer server) {
        if (this.prepareData(false)) {
            class_2540 buf = PacketByteBufs.create();
            this.serializeData(buf, false);
            DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), buf);
        }
    }

    @Override
    void sendToClient(MinecraftServer server, class_3222 player) {
        if (this.prepareData(false)) {
            class_2540 buf = PacketByteBufs.create();
            this.serializeData(buf, false);
            DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), buf);
        }
    }

    public static void _sendToClient(class_2960 identifier, MinecraftServer server, Collection<class_3222> players, class_2540 buf) {
        if (buf.readableBytes() > 0x100000) {
            Chunker.PacketChunkSender sender = new Chunker.PacketChunkSender(buf, identifier);
            sender.sendChunks(players);
        } else {
            for (class_3222 player : players) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)identifier, (class_2540)buf);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    void sendToServer(class_310 client) {
        if (this.prepareData(true)) {
            class_2540 buf = PacketByteBufs.create();
            this.serializeData(buf, true);
            ClientPlayNetworking.send((class_2960)this.getIdentifier(), (class_2540)buf);
        }
    }

    public static abstract class FromServer
    extends BaseDataHandler {
        protected FromServer(class_2960 identifier) {
            super(identifier, true);
        }

        protected boolean prepareDataOnServer() {
            return true;
        }

        protected abstract void serializeDataOnServer(class_2540 var1);

        @Environment(value=EnvType.CLIENT)
        protected abstract void deserializeIncomingDataOnClient(class_2540 var1, PacketSender var2);

        @Environment(value=EnvType.CLIENT)
        protected abstract void runOnClientGameThread(class_310 var1);

        @Override
        @Environment(value=EnvType.CLIENT)
        final void receiveFromServer(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            this.deserializeIncomingDataOnClient(buf, responseSender);
            Runnable runner = () -> this.runOnClientGameThread(client);
            if (this.isBlocking()) {
                client.method_19537(runner);
            } else {
                client.execute(runner);
            }
        }

        @Override
        final void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, buf, responseSender);
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the server!");
        }

        public void receiveFromMemory(class_2540 buf) {
            this.receiveFromServer(class_310.method_1551(), null, buf, null);
        }

        @Override
        final void sendToClient(MinecraftServer server) {
            if (this.prepareDataOnServer()) {
                class_2540 buf = PacketByteBufs.create();
                this.serializeDataOnServer(buf);
                DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), buf);
            }
        }

        @Override
        final void sendToClient(MinecraftServer server, class_3222 player) {
            if (this.prepareDataOnServer()) {
                class_2540 buf = PacketByteBufs.create();
                this.serializeDataOnServer(buf);
                DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), buf);
            }
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        final void sendToServer(class_310 client) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the server!");
        }

        public static abstract class WithoutPayload
        extends FromServer {
            protected WithoutPayload(class_2960 identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnServer() {
                return true;
            }

            @Override
            protected void serializeDataOnServer(class_2540 buf) {
            }

            @Override
            protected void deserializeIncomingDataOnClient(class_2540 buf, PacketSender responseSender) {
            }
        }
    }

    public static abstract class FromClient
    extends BaseDataHandler {
        protected FromClient(class_2960 identifier) {
            super(identifier, false);
        }

        @Environment(value=EnvType.CLIENT)
        protected boolean prepareDataOnClient() {
            return true;
        }

        @Environment(value=EnvType.CLIENT)
        protected abstract void serializeDataOnClient(class_2540 var1);

        protected abstract void deserializeIncomingDataOnServer(class_2540 var1, class_1657 var2, PacketSender var3);

        protected abstract void runOnServerGameThread(MinecraftServer var1, class_1657 var2);

        @Override
        @Environment(value=EnvType.CLIENT)
        void receiveFromServer(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the client!");
        }

        @Override
        void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, buf, responseSender);
            this.deserializeIncomingDataOnServer(buf, (class_1657)player, responseSender);
            Runnable runner = () -> this.runOnServerGameThread(server, (class_1657)player);
            if (this.isBlocking()) {
                server.method_19537(runner);
            } else {
                server.execute(runner);
            }
        }

        @Override
        void sendToClient(MinecraftServer server) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the client!");
        }

        @Override
        void sendToClient(MinecraftServer server, class_3222 player) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the client!");
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        void sendToServer(class_310 client) {
            if (this.prepareDataOnClient()) {
                class_2540 buf = PacketByteBufs.create();
                this.serializeDataOnClient(buf);
                ClientPlayNetworking.send((class_2960)this.getIdentifier(), (class_2540)buf);
            }
        }

        public static abstract class WithoutPayload
        extends FromClient {
            protected WithoutPayload(class_2960 identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnClient() {
                return true;
            }

            @Override
            protected void serializeDataOnClient(class_2540 buf) {
            }

            @Override
            protected void deserializeIncomingDataOnServer(class_2540 buf, class_1657 player, PacketSender responseSender) {
            }
        }
    }

    public static abstract class WithoutPayload
    extends DataHandler {
        protected WithoutPayload(class_2960 identifier, boolean originatesOnServer) {
            super(identifier, originatesOnServer);
        }

        @Override
        protected boolean prepareData(boolean isClient) {
            return true;
        }

        @Override
        protected void serializeData(class_2540 buf, boolean isClient) {
        }

        @Override
        protected void deserializeIncomingData(class_2540 buf, PacketSender responseSender, boolean isClient) {
        }
    }
}

